//
//  AGTemplate.h
//  1Passwd
//
//  Created by Roustem Karimov on 09-11-03.
//  Copyright 2007 AgileBits Inc. All rights reserved.
//

@import Foundation;

#if TARGET_OS_IPHONE
@import UIKit;
#endif

#import "OPItemField.h"
#import "OPItemStringField.h"
#import "OPItemConcealedField.h"
#import "OPItemMenuField.h"
#import "OPItemPhoneField.h"
#import "OPItemDateField.h"
#import "OPItemCountryField.h"
#import "OPItemMonthYearField.h"
#import "OPFieldSection.h"

@class B5TemplateProperties;

@interface OPTemplate : NSObject

@property (nonatomic, copy) NSURL * templateURL;

@property (nonatomic, readonly) NSString * uuid;
@property (nonatomic, readonly) NSString * subtitleFieldName;
@property (nonatomic, readonly) NSString * listIconName;
@property (nonatomic, readonly) NSString * detailIconName;
@property (nonatomic, readonly) NSString * sourceIconName;
@property (nonatomic, assign) BOOL localized;
@property (nonatomic, assign) BOOL hidden;
@property (nonatomic, assign) BOOL deprecated;
@property (nonatomic, readonly) B5TemplateProperties *b5TemplateProperties;
@property (nonatomic, readonly) NSDictionary *definition;

- (id)initWithDefinition:(NSDictionary *)definition;
- (instancetype)initWithDefinition:(NSDictionary *)definition b5TemplateDictionary:(NSDictionary *)b5TemplateDictionary;

- (NSArray *)instantiateFieldSections;
- (BOOL)visible;

- (NSString *)localizedStringForKey:(NSString *)key;
- (NSString *)localizedTitle;
- (NSString *)localizedPluralTitle;

- (NSArray *)menuItemsForFieldIdentifier:(NSString *)identifier;
- (NSArray *)localizedMenuLabelsForFieldIdentifier:(NSString *)identifier;

- (NSString *)localizedValueForFieldIdentifier:(NSString *)identifier menuValue:(NSString *)menuValue;

#if TARGET_OS_IPHONE
- (id<UITextInputTraits>)textInputTraitsForFieldIdentifier:(NSString *)fieldIdentifier;
#endif

@end
